% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{coxphControl}
\alias{coxphControl}
\title{Control of Cox Proportional Hazards Model Fitting}
\usage{
coxphControl(cut_num = 8, lhaz_prior = 3)
}
\arguments{
\item{cut_num}{positive integer specifying the number of time intervals to include in
the piecewise exponential hazard model assumptions for the sampling step. Default is 8.
General recommendation: use between 5 and 10 intervals. See the Details section for
additional information.}

\item{lhaz_prior}{positive numeric value specifying the standard deviation of the 
multivariate normal prior for the log of the baseline hazard values for each time interval.
Default is 3. If encounter convergence issues, the user can consider 
increasing or decreasing this value (e.g. increase to 4 or decrease to 2 ...).}
}
\value{
Function returns a list inheriting from class \code{optimControl}
containing fit and optimization criteria values used in optimization routine.
}
\description{
Constructs the control structure for additional parameters needed for
the sampling and optimization routines involving the Cox Proportional Hazards model fit algorithm
}
\details{
In the piecewise exponential hazard model assumption---which is assumed in the 
sampling step (E-step) for the Cox PH family---there is an assumption that the 
time line of the data can be cut into \code{cut_num}
time intervals and the baseline hazard is constant within
each of these time intervals. In the sampling step, we need to estimate
these baseline hazard values (specifically, we estimate the log of the baseline
hazard values). We determine cut points by specifying the total number of cuts
to make (\code{cut_num}) and then specifying time values for cut points such
that each time interval has an equal number (or approximately equal number) 
of events. Each time interval must have at least one event for the model
to be identifiable, but more events per time interval is better. 
Consequently, having too many cut points could result in (i) not having enough
events for each time interval and/or (ii) significantly slowing down the 
sampling step due to requiring the estimation of many log baseline hazard values.
Additionally, data with few events could result too few events per time interval
even for a small number of cut points. We generally recommend having
8 total time intervals (more broadly, between 5 and 10). Warnings or errors
will occur for cases when there are 1 or 0 events for a time interval. 
If this happens, either adjust the \code{cut_num} value appropriately,
or in the case when the data simply has a very small number of events,
consider not using this software for your estimation purposes.
}
