% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPlot.R
\name{modelPlot}
\alias{modelPlot}
\title{Model plot}
\usage{
modelPlot(
  glmmResult,
  geneName,
  x1Label = "Timepoint",
  x2Label,
  xTitle = NULL,
  yTitle = "Gene Expression",
  title = NULL,
  logTransform = FALSE,
  shapes = 19,
  colours = c("blue"),
  x2Offset = 6,
  lineWidth = 1,
  markerSize = 5,
  fontSize = NULL,
  overlap = TRUE,
  addErrorbars = TRUE,
  graphics = "ggplot",
  ...
)
}
\arguments{
\item{glmmResult}{A glmmSeq object created by
\code{\link[glmmSeq:glmmSeq]{glmmSeq::glmmSeq()}}..}

\item{geneName}{Gene/row name to plot}

\item{x1Label}{The name of the first (inner) x parameter}

\item{x2Label}{The name of the second (outer) x parameter}

\item{xTitle}{Title for the x axis}

\item{yTitle}{Title for the y axis}

\item{title}{Plot title. If NULL gene name is used.}

\item{logTransform}{Whether to perform a log10 transform on the y axis}

\item{shapes}{The marker shapes, default=19}

\item{colours}{The marker colours, default=c('blue')}

\item{x2Offset}{Vertical adjustment to secondary x-axis (default=6)}

\item{lineWidth}{Plot line size (default=1)}

\item{markerSize}{Size of markers (default=5)}

\item{fontSize}{Plot font size (default=10)}

\item{overlap}{Logical whether x2Label fits should be plotted overlapping one
another (default=TRUE).}

\item{addErrorbars}{Logical whether to add error bars.}

\item{graphics}{Which graphic system to use (options = "base" or "ggplot")}

\item{...}{Other parameters to pass to
\code{\link[graphics:plot]{graphics::plot()}} or
\code{\link[ggplot2:theme]{ggplot2::theme()}}.}
}
\value{
Returns a plot with the glmm fit for a given gene/row
}
\description{
Model plots to show the overall differences between groups and over time
}
\examples{
data(PEAC_minimal_load)
disp <- apply(tpm, 1, function(x){
(var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})
Fit <- glmmSeq(~ Timepoint * EULAR_6m + (1 | PATID),
                     id = 'PATID',
                     countdata = tpm['ADAM12', ],
                     metadata = metadata,
                     dispersion = disp,
                     verbose=FALSE)
modelPlot(Fit,
          "ADAM12",
          x1Label="Timepoint",
          x2Label="EULAR_6m",
          colours = c('skyblue', 'goldenrod1', 'mediumvioletred'),
          xTitle="Time",
          markerSize=3,
          graphics="base")
}
