% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6meanfunction.R
\name{MeanFunction}
\alias{MeanFunction}
\title{R6 Class representing a mean function function and data}
\description{
R6 Class representing a mean function function and data

R6 Class representing a mean function function and data
}
\details{
For the generalised linear mixed model 

\deqn{Y \sim F(\mu,\sigma)}
\deqn{\mu = h^-1(X\beta + Z\gamma)}
\deqn{\gamma \sim MVN(0,D)}

this class defines the family F, link function h, and fixed effects design matrix X. 
The mean function is defined by a model formula, data, and parameters.
A new instance can be generated with $new(). The class will generate the 
relevant matrix X automatically. See \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a 
detailed guide on model specification.


Specification of the mean function follows standard model formulae in R. 
For example for a stepped-wedge cluster trial model, a typical mean model is 
\eqn{E(y_{ijt}|\delta)=\beta_0 + \tau_t + \beta_1 d_{jt} + z_{ijt}\delta} where \eqn{\tau_t} 
are fixed effects for each time period. The formula specification for this would be `~ factor(t) + int` 
where `int` is the name of the variable indicating the treatment.

One can also include non-linear functions of variables in the mean function. These are handled in the analyses 
by first-order approximation.
}
\examples{

## ------------------------------------------------
## Method `MeanFunction$n`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$n()

## ------------------------------------------------
## Method `MeanFunction$check`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$parameters <- c(0,0)
mf1$check()

## ------------------------------------------------
## Method `MeanFunction$new`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )

## ------------------------------------------------
## Method `MeanFunction$colnames`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$colnames(c("cluster","time","individual","treatment"))
mf1$colnames()

## ------------------------------------------------
## Method `MeanFunction$subset_rows`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$subset_rows(1:20) 

## ------------------------------------------------
## Method `MeanFunction$subset_cols`
## ------------------------------------------------

df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$subset_cols(1:2) 
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{formula}}{model formula for the fixed effects}

\item{\code{data}}{Data frame with data required to build X}

\item{\code{family}}{One of the family function used in R's glm functions. See \link[stats]{family} for details}

\item{\code{parameters}}{A vector of parameter values for \eqn{\beta} used for simulating data and calculating
covariance matrix of observations for non-linear models.}

\item{\code{randomise}}{A function that generates a new set of values representing the treatment allocation in an 
experimental study}

\item{\code{treat_var}}{A string naming the column in data that represents the treatment variable in data. Used
to identify where to replace allocation when randomiser is used.}

\item{\code{X}}{the fixed effects design matrix}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MeanFunction-n}{\code{MeanFunction$n()}}
\item \href{#method-MeanFunction-check}{\code{MeanFunction$check()}}
\item \href{#method-MeanFunction-new}{\code{MeanFunction$new()}}
\item \href{#method-MeanFunction-print}{\code{MeanFunction$print()}}
\item \href{#method-MeanFunction-colnames}{\code{MeanFunction$colnames()}}
\item \href{#method-MeanFunction-subset_rows}{\code{MeanFunction$subset_rows()}}
\item \href{#method-MeanFunction-subset_cols}{\code{MeanFunction$subset_cols()}}
\item \href{#method-MeanFunction-rerandomise}{\code{MeanFunction$rerandomise()}}
\item \href{#method-MeanFunction-clone}{\code{MeanFunction$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-n"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-n}{}}}
\subsection{Method \code{n()}}{
Returns the number of observations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$n()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The number of observations in the model
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$n()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-check"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-check}{}}}
\subsection{Method \code{check()}}{
Checks if any changes have been made and updates

Checks if any changes have been made and updates, usually called automatically.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$check(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical whether to report if any changes detected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$parameters <- c(0,0)
mf1$check()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-new"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-new}{}}}
\subsection{Method \code{new()}}{
Create a new MeanFunction object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$new(
  formula,
  data,
  family,
  parameters,
  verbose = FALSE,
  random_function = NULL,
  treat_var = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{A \link[stats]{formula} object that describes the mean function, see Details}

\item{\code{data}}{A data frame containing the covariates in the model, named in the model formula}

\item{\code{family}}{A family object expressing the distribution and link function of the model, see \link[stats]{family}}

\item{\code{parameters}}{A vector with the values of the parameters \eqn{\beta} to use in data simulation and covariance calculations}

\item{\code{verbose}}{Logical indicating whether to report detailed output}

\item{\code{random_function}}{A string naming a function in the global environment that produces a vector of data describing a new
treatment allocation in an experimental model. When used, the output of this function replaces the column of data named by
`treat_var`}

\item{\code{treat_var}}{The name of a column in data (or the name to give a new column) that a random treatment allocation generated
by `random_function` replaces.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A MeanFunction object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-print"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-print}{}}}
\subsection{Method \code{print()}}{
Prints details about the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-colnames"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-colnames}{}}}
\subsection{Method \code{colnames()}}{
Returns or replaces the column names of the data in the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$colnames(names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{If NULL then the function prints the column names, if a vector of names, then it attemps to 
replace the current column names of the data}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$colnames(c("cluster","time","individual","treatment"))
mf1$colnames()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-subset_rows"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-subset_rows}{}}}
\subsection{Method \code{subset_rows()}}{
Keeps a subset of the data and removes the rest

All indices not in the provided vector of row numbers will be removed from both the data and fixed effects 
design matrix X.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$subset_rows(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Rows of the data to keep}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$subset_rows(1:20) 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-subset_cols"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-subset_cols}{}}}
\subsection{Method \code{subset_cols()}}{
Keeps a subset of the columns of X 

All indices not in the provided vector of column numbers will be removed from the fixed effects design
matrix X.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$subset_cols(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{Columns of X to keep}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(4)*t(5)) > ind(5))
df$int <- 0
df[df$cl <= 5, 'int'] <- 1
mf1 <- MeanFunction$new(formula = ~ int ,
                        data=df,
                        parameters = c(-1,1),
                        family = stats::binomial()
                        )
mf1$subset_cols(1:2) 
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-rerandomise"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-rerandomise}{}}}
\subsection{Method \code{rerandomise()}}{
Generates a new random allocation

If a randomising function has been provided then a new random allocation will
be generated, and will replace the exisitng data at `treat_var` in the X matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$rerandomise()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing is returned, the X matrix is updated
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MeanFunction-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MeanFunction-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeanFunction$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
