% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ann_tab_cv_230509.R
\name{ann_tab_cv_best}
\alias{ann_tab_cv_best}
\title{Fit multiple Artificial Neural Network models on "tabular" provided as a matrix, and 
keep the best one.}
\usage{
ann_tab_cv_best(
  myxs,
  mystart = NULL,
  myy,
  myevent = NULL,
  myoffset = NULL,
  family = "binomial",
  fold_n = 10,
  epochs = 200,
  eppr = 40,
  lenz1 = 32,
  lenz2 = 8,
  mylr = 0.005,
  actv = 1,
  wd = 0,
  drpot = 0,
  lasso = 0,
  adjustw = 1,
  bestof = 10
)
}
\arguments{
\item{myxs}{predictor input - an n by p matrix, where n (rows) is sample size, and p (columns) 
the number of predictors.  Must be in matrix form for complete data, no NA's, no Inf's, etc.,
and not a data frame.}

\item{mystart}{an optional vector of start times in case of a Cox model. Class numeric of length same as number of patients (n)}

\item{myy}{dependent variable as a vector: time, or stop time for Cox model, Y_ 0 or 1 for binomial (logistic), numeric for gaussian. 
Must be a vector of length same as number of sample size.}

\item{myevent}{event indicator, 1 for event, 0 for census, Cox model only.
Must be a numeric vector of length same as sample size.}

\item{myoffset}{an offset term to be ues when fitting the ANN.  Not yet implemented.}

\item{family}{model family, "cox", "binomial" or "gaussian" (default)}

\item{fold_n}{number of folds for each level of cross validation}

\item{epochs}{number of epochs to run when tuning on number of epochs for fitting 
final model number of epochs informed by cross validation}

\item{eppr}{for EPoch PRint.  print summry info every eppr epochs. 0 will 
print first and last epochs, -1 nothing.}

\item{lenz1}{length of the first hidden layer in the neural network, default 16}

\item{lenz2}{length of the second hidden layer in the neural network, default 16}

\item{mylr}{learning rate for the optimzaiton step in teh neural network model fit}

\item{actv}{for ACTiVation function.  Activation function between layers, 
1 for relu, 2 for gelu, 3 for sigmoid.}

\item{wd}{weight decay for the model fit.}

\item{drpot}{fraction of weights to randomly zero out.  NOT YET implemented.}

\item{lasso}{1 to indicate the first collumn of the input matrix is an offset 
term, often derived from a lasso model}

\item{adjustw}{1 as default to re-adjust weights to account for the offset every 
epoch.  This is only used in case lasso is set to 1}

\item{bestof}{how many models to run, from which the best fitting model will be selected.}
}
\value{
an artifical neural network model fit
}
\description{
Fit an multiple Artificial Neural Network model for analysis of "tabular" 
data using ann_tab_cv() and select the best fitting model according to cross
validaiton.
}
\seealso{
\code{\link{ann_tab_cv}} , \code{\link{nested.glmnetr}} , \code{\link{summary.nested.glmnetr}} , \code{\link{glmnetr.compcv}} , \code{\link{glmnetr.simdata}}
}
