% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.glmnetr_240322.R
\name{predict.cv.glmnetr}
\alias{predict.cv.glmnetr}
\title{Give predicteds based upon a cv.glmnetr() output object.}
\usage{
\method{predict}{cv.glmnetr}(object, xs_new = NULL, lam = NULL, gam = NULL, comment = TRUE, ...)
}
\arguments{
\item{object}{A cv.glmnetr (or nested.glmnetr) output object.}

\item{xs_new}{The predictor matrix.  If NULL, then betas are provided.}

\item{lam}{The lambda value for choice of beta.  If NULL, then 
lambda.min is used from the cross validated tuned relaxed model.  We
use the term lam instead of lambda as lambda usually denotes a vector 
in the package.}

\item{gam}{The gamma value for choice of beta.  If NULL, then 
gamma.min is used from the cross validated tuned relaxed model.  We
use the term gam instead of gamma as gamma usually denotes a vector 
in the package.}

\item{comment}{Default of TRUE to write to console information on lam and gam selected for output.
FALSE will suppress this write to console.}

\item{...}{Additional arguments passed to the predict function.}
}
\value{
Either predicteds (xs_new*beta estimates based upon the predictor matrix xs_new)  
or model coefficients, based upon a cv.glmnetr() output object.  When 
outputting coefficients (beta), creates a list 
with the first element, beta_, including 0 and non-0 terms and the 
second element, beta, including only non 0 terms.
}
\description{
Give predicteds based upon a cv.glmnetr() output object. By default lambda and gamma 
are chosen as the minimizing values for the relaxed lasso model.  If gam=1 and lam=NULL 
then the best unrelaxed lasso model is chosen and if gam=0 and lam=NULL then
the best fully relaxed lasso model is selected.
}
\examples{
# set seed for random numbers, optionally, to get reproducible results
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=200, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$y_ 
event=sim.data$event
# for this example we use a small number for folds_n to shorten run time 
cv.glmnetr.fit = cv.glmnetr(xs, NULL, y_, NULL, family="gaussian", folds_n=3, limit=2) 
predict(cv.glmnetr.fit)

}
\seealso{
\code{\link{summary.cv.glmnetr}} , \code{\link{cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
