% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_score.r
\name{compute_score}
\alias{compute_score}
\alias{compute_score.numeric}
\alias{compute_score.list}
\alias{compute_voi}
\title{Compute keyword-country search score}
\usage{
compute_score(object, control = 1, locations = gt.env$countries)

\method{compute_score}{numeric}(object, control = 1, locations = gt.env$countries)

\method{compute_score}{list}(object, control = 1, locations = gt.env$countries)

compute_voi(object, control = 1)
}
\arguments{
\item{object}{Object batch for which the data is downloaded. Object
of type \code{numeric} or object of type \code{list} containing single
objects of type \code{numeric}.}

\item{control}{Control batch for which the data is downloaded. Object
of type \code{numeric}. Defaults to 1.}

\item{locations}{List of countries or regions for which the data is
downloaded. Refers to lists generated in \code{start_db}. Defaults to
\code{countries}.}
}
\value{
Message that data has been computed successfully. Data is written to
table \emph{data_score}.
}
\description{
The function computes search scores for object keywords. Search volumes for
control and object batches are mapped to the same base. Next, search volumes
for object batches are divided by the sum of search volumes for the
respective control batch. \code{compute_voi} computes volume of
internationalization (VOI) as global search scores.
}
\details{
The search score computation proceeds in four steps. First, the function
aggregates all search volumes to monthly data. Then, it applies some optional
time series adjustments: seasonally adjusted \code{\link[forecast:seasadj]{forecast::seasadj}} and
trend only \code{\link[stats:stl]{stats::stl}}. Next, it follows the procedure outlined by
Castelnuovo and Tran (2017, pp. A1-A2) to map control and object data. After
the mapping, object search volumes are divided by the sum of control search
volumes in the respective control batch. We use the sum of search volumes for
a set of control keywords, rather than the search volumes for a single
control keyword, to smooth-out variation in the underlying control data. When
synonyms were specified through \code{add_synonym}, search scores for
synonyms are added to the main keyword.

\emph{Castelnuovo, E. & Tran, T. D. 2017. Google It Up! A Google Trends-based
Uncertainty index for the United States and Australia. Economics Letters,
161: 149-153.}
}
\examples{
\dontrun{
compute_score(
  object = 1,
  control = 1,
  locations = countries
)
compute_voi(
  object = 1,
  control = 1
)
compute_score(
  object = as.list(1:5),
  control = 1,
  locations = countries
)
}

}
\seealso{
\itemize{
\item \code{\link[=example_score]{example_score()}}
\item \code{\link[=add_synonym]{add_synonym()}}
\item \code{\link[stats:stl]{stats::stl()}}
\item \code{\link[forecast:seasadj]{forecast::seasadj()}}
}
}
