% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottocreate.R
\name{glottocreate}
\alias{glottocreate}
\title{Generate empty glottodata or glottosubdata for a set of glottocodes.}
\usage{
glottocreate(
  glottocodes,
  variables,
  meta = TRUE,
  filename = NULL,
  simplify = TRUE,
  groups = NULL,
  n = NULL,
  levels = NULL,
  check = FALSE,
  maintainer = NULL,
  email = NULL,
  citation = NULL,
  url = NULL
)
}
\arguments{
\item{glottocodes}{Character vector of glottocodes}

\item{variables}{Either a vector with variable names, or a single number indicating the total number of variable columns to be generated}

\item{meta}{Should metatables be created?}

\item{filename}{Optional name of excel file where to store glottodata}

\item{simplify}{By default, if a glottodata table is created without metadata, the data will be returned as a data.frame (instead of placing the data inside a list of length 1)}

\item{groups}{Character vector of group names (only for glottosubdata)}

\item{n}{Optional, number of records to be assigned to each group (only for glottosubdata)}

\item{levels}{Optional character vector with levels across all variables}

\item{check}{Should glottocodes be checked? Default is FALSE because takes much time to run.}

\item{maintainer}{Name of the person/organization maintaining the data (optional)}

\item{email}{Email address of maintainer/contact person (optional)}

\item{citation}{How to cite the data (optional)}

\item{url}{Optional url linking to a webpage.}
}
\value{
A glottodata or glottosubdata object (either with or without metadata). The output can be a list or a data.frame.
}
\description{
By default, glottodata will be created. In case a groups argument is provided, glottosubdata will be created.
}
\details{
glottodata has one table for all languages (and a number of metatables if meta = TRUE), with one row per glottocode.
glottosubdata has one table for each language (and a number of metatables if meta = TRUE), with one row per glottosubcode.

Run glottoget("demodata") or glottoget("demosubdata") to see examples.

In case you already have your own dataset and want to convert it into glottodata, use: glottoconvert().
}
\examples{
# Creates glottodata table without metadata tables
glottocreate(glottocodes = c("yucu1253", "tani1257"),
variables = 3, meta = FALSE)

# Creates glottodata table with metadata tables (stored in a list):
glottocreate(glottocodes = c("yucu1253", "tani1257"), variables = 3)


# Creates glottosubdata table (stored in a list)
glottocreate(glottocodes = c("yucu1253", "tani1257"),
variables = 3, groups = c("a", "b") )

# Creates glottodata/glottosubdata and save excel file in specified directory:
\donttest{
glottocreate(glottocodes = c("yucu1253", "tani1257"),
             variables = 3,
             filename = file.path(tempdir(), "glottodata.xlsx") )

glottocreate(glottocodes = c("yucu1253", "tani1257"),
             variables = 3, groups = c("a", "b"),
             filename = file.path(tempdir(), "glottosubdata.xlsx") )
}
}
\concept{<glottoget><glottocreate>}
