% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{additive_alpha}
\alias{additive_alpha}
\title{additive_alpha}
\usage{
additive_alpha(colors)
}
\arguments{
\item{colors}{colors}
}
\value{
A simulated additive scale of the input colors.
}
\description{
Simulates additive blending on a dark to light color scale.
}
\details{
In R plotting (both ggplot and base R) blending is performed by alpha blending, which is an averaging effect. When combining light and glow effects, additive blending is more appropriate. 

This function simulates additive blending by increasing color on a color scale to compensate for the averaging effect of alpha blending. 

Note: this function is only appropriate for dark to light color scales.
}
\examples{
m_solid <- viridisLite::magma(12)
m_additive <- additive_alpha(m_solid)
}
