\name{getRowDualGLPK}
\alias{getRowDualGLPK}
\alias{glp_get_row_dual}

\title{
  Retrieve Row Dual Value
}

\description{
  Low level interface function to the GLPK function \code{glp_get_row_dual}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  getRowDualGLPK(lp, i)
}

\arguments{
  \item{lp}{
    An object of class \code{"\linkS4class{glpkPtr}"} as returned by
    \code{\link{initProbGLPK}}. This is basically a pointer to a GLPK problem
    object.
  }
  \item{i}{
    Row number \code{i}.
  }
}

\details{
  Interface to the C function \code{getRowDual} which calls the GLPK
  function \code{glp_get_row_dual}.
}

\value{
  Row dual value
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee.
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }
