% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variograms.R
\name{length.gmCgram}
\alias{length.gmCgram}
\alias{ncol.gmCgram}
\alias{nrow.gmCgram}
\title{Length, and number of columns or rows}
\usage{
\method{length}{gmCgram}(x)
}
\arguments{
\item{x}{gmCgram object}
}
\value{
\code{length} returns the number of structures (nugget not counted), while
\code{ncol} and \code{nrow} return these values for the nugget (assuming that they will
be also valid for the sill).
}
\description{
Provide number of structures, and nr of variables of an LMC of class gmCgram
}
\examples{
utils::data("variogramModels")
v1 = setCgram(type=vg.Gau, sill=diag(3)+0.5, anisRanges = 2*diag(c(3,0.5)))
v2 = setCgram(type=vg.Exp, sill=0.3*diag(3), anisRanges = 0.5*diag(2))
vm = v1+v2
length(vm)
ncol(vm)
nrow(vm)
}
\seealso{
Other gmCgram functions: 
\code{\link{[.gmCgram}()},
\code{\link{[[.gmCgram}()},
\code{\link{as.function.gmCgram}()},
\code{\link{as.gmCgram.variogramModelList}()},
\code{\link{ndirections}()},
\code{\link{plot.gmCgram}()},
\code{\link{variogramModelPlot}()}
}
\concept{gmCgram functions}
