% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simplify_ontology.R
\name{treemap_data}
\alias{treemap_data}
\title{Construct tree and treemap data structures from geneset parent/child relations}
\usage{
treemap_data(
  geneset_ids,
  genesets,
  genesets_test_result,
  simplify = "none",
  toplevel_max_ngenes = NA
)
}
\arguments{
\item{geneset_ids}{vector of geneset identifiers}

\item{genesets}{entire geneset table; typically the complete GO database}

\item{genesets_test_result}{geneset testing results; the output from \code{test_genesets()}}

\item{simplify}{strategy for reducing the genesets returned in the treemap. Options;
"leaf_only" (most stringent, returns only leaves in the tree structure)
"prune_singletons" (remove parent terms that have exactly 1 child)
"pvalue" (remove parent terms where the child term p-value is at least 4 times better)
"none" (default; return all significant genesets that are not a "grouping term" in the treemap)}

\item{toplevel_max_ngenes}{groups in the treemap should not have more than this many genes ('ngenes' in geneset test results). If not set, this defaults to 50\% of the total number of unique genes in the geneset test results}
}
\value{
data structure needed for \code{treemap_plot()}
}
\description{
refer to the goat::treemap_plot() function for a complete example
}
