% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specresponses.R
\name{specresponses}
\alias{specresponses}
\title{Multiple species response curves}
\usage{
specresponses(matrix, var, main, xlab, model = "unimodal", method = "env",
  axis = 1, points = FALSE, bw = FALSE)
}
\arguments{
\item{matrix}{Community data, a matrix-like object with samples in rows and species in columns. Response curves are drawn for all (selected) columns (species).}

\item{var}{Vector containing environmental variable (per plot) \strong{OR} \code{vegan} ordination result object if \code{method = "ord"}.}

\item{main}{Optional: Main title.}

\item{xlab}{Optional: Label of x-axis.}

\item{model}{Defining the assumed species responses: Default \code{method = "unimodal"} fits unimodal responses. Other methods are \code{method = "linear"} (linear responses), \code{method = "bimodal"} (bimodal responses), \code{method = "auto"} (automatic selection based on AIC) and \code{method = "gam"} (using GAM with smoother).}

\item{method}{Method defining the type of variable. Default \code{method = "env"} fits a response curve to environmental variables. Alternatively \code{method = "ord"} fits a response along ordination axes.}

\item{axis}{Ordination axis (only if \code{method = "ord"}).}

\item{points}{If set on \code{TRUE} the species occurences are shown as points. To avoid overlapping they are shown with vertical offset.}

\item{bw}{If set on \code{TRUE} the lines will be drawn in black/white with different line types instead of colours.}
}
\description{
This function fits  multiple species response curves to visualize species responses to environmental gradients or ordination axes.
It is based on Logistic Regression using Generalised Linear Models (GLMs) or Generalized Additive Models (GAMs) with integrated smoothness estimation.
In contrast to \code{\link{specresponse}} this function can draw multiple curves into one plot.
}
\section{Details}{

For response curves based on environmental gradients the argument \code{var} takes a single vector containing the variable corresponding to the species abundances.

For a response to ordination axis (\code{method = "ord"}) the argument \code{var} requires a \code{vegan} ordination result object (e.g. from \code{\link[vegan]{decorana}}, \code{\link[vegan]{cca}}, \code{\link[vegan]{rda}} or \code{\link[vegan]{metaMDS}}).
First axis is used as default.

If you plot a response curve for only one species the use of \code{\link{specresponse}} is recommended.
}
\examples{
## Species (columns) need to be selected; call names() to get column numbers
names(schedenveg)
## Draw multiple species response curves on variable in black/white
specresponses(schedenveg[ ,c(9,18,14,19)], schedenenv$height_herb, bw = TRUE)

## Draw the same curves based on GAM
specresponses(schedenveg[ ,c(9,18,14,19)], schedenenv$height_herb, bw = TRUE, model = "gam")

## Draw multiple species response curves on variable with
## custom x-axis label and points of occurences
specresponses(schedenveg[ ,c(9,18,14,19)], schedenenv$height_herb,
    xlab = "Height of herb layer (cm)", points = TRUE)

## Draw multiple species response curves on ordination axes
## First calculate DCA
library(vegan)
scheden.dca <- decorana(schedenveg)
specresponses(schedenveg[ ,c(9,18,14,19)], scheden.dca, method = "ord")
specresponses(schedenveg[ ,c(9,18,14,19)], scheden.dca, method = "ord", axis = 2)


}
\author{
Friedemann Goral (\email{fgoral@gwdg.de})
}
\seealso{
\code{\link{specresponse}}
}

