% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigQuery.R
\name{google_analytics_bq}
\alias{google_analytics_bq}
\title{Get Google Analytics 360 BigQuery data}
\usage{
google_analytics_bq(
  projectId,
  datasetId,
  start = NULL,
  end = NULL,
  metrics = NULL,
  dimensions = NULL,
  sort = NULL,
  filters = NULL,
  max_results = 100,
  query = NULL,
  return_query_only = FALSE,
  bucket = NULL,
  download_file = NULL
)
}
\arguments{
\item{projectId}{The Google project Id where the BigQuery exports sit}

\item{datasetId}{DatasetId of GA export.  This should match the GA View ID}

\item{start}{start date}

\item{end}{end date}

\item{metrics}{metrics to query}

\item{dimensions}{dimensions to query}

\item{sort}{metric to sort by}

\item{filters}{filter results}

\item{max_results}{How many results to fetch}

\item{query}{If query is non-NULL then it will use that and ignore above}

\item{return_query_only}{Only return the constructed query, don't call BigQuery}

\item{bucket}{if over 100000 results, specify a Google Cloud bucket to send data to}

\item{download_file}{Where to save asynch files.  If NULL saves to current working directory.}
}
\value{
data.frame of results
}
\description{
Turn a google_analytics style call into BigQuery SQL.
Used with Google Analytics 360 BigQuery exports.
}
\details{
All data will be unsampled, and requests will cost money against your BigQuery quota.

Requires installation of bigQueryR and authentication under ga_bq_auth()
or googleAuthR::gar_auth() with BigQuery scope set.
View your projectIds upon authentication via \code{\link[bigQueryR:bqr_list_projects]{bigQueryR::bqr_list_projects()}}

No segments for now.

Goals are not specified in BQ exports, so you need to look at how you define them and replicate per view
e.g. unique pageviews or unique events.

Custom dimensions can be specified as session or hit level, so ignoring the setting in GA interface.

You can get a sample Google Analytics dataset in bigquery by following the instructions
here: \url{https://support.google.com/analytics/answer/3416091?hl=en}
}
\seealso{
\url{https://support.google.com/analytics/answer/4419694?hl=en}
\url{https://support.google.com/analytics/answer/3437719?hl=en}
}
