% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-modifyurl.R
\name{gar_shiny_ui}
\alias{gar_shiny_ui}
\title{Create a Google login before your Shiny UI launches}
\usage{
gar_shiny_ui(ui, login_ui = silent_auth)
}
\arguments{
\item{ui}{A Shiny ui object}

\item{login_ui}{A UI or HTML template that is seen before the main app and contains a login in link generated by \link{gar_shiny_auth_url}}
}
\description{
A function that will turn your ui object into one that will look for Google 
  authentication before loading the main app. Use together with \link{gar_shiny_auth}
}
\details{
Put this at the bottom of your ui.R or pass into \link[shiny]{shinyApp} wrapping your created ui.
}
\examples{

\dontrun{
library(shiny)
library(googleAuthR)
gar_set_client()

fileSearch <- function(query) {
  googleAuthR::gar_api_generator("https://www.googleapis.com/drive/v3/files/",
                                "GET",
                                pars_args=list(q=query),
                                data_parse_function = function(x) x$files)()
}

## ui.R
ui <- fluidPage(title = "googleAuthR Shiny Demo",
                textInput("query", 
                label = "Google Drive query", 
                value = "mimeType != 'application/vnd.google-apps.folder'"),
                tableOutput("gdrive")
                )
                
## server.R
server <- function(input, output, session){

# this is not reactive, no need as you only reach here authenticated
gar_shiny_auth(session)

output$gdrive <- renderTable({
  req(input$query)
  
  # no need for with_shiny()
  fileSearch(input$query)
  
  })
  }

# gar_shiny_ui() needs to wrap the ui you have created above.
shinyApp(gar_shiny_ui(ui), server)
}
}
\seealso{
Other pre-load shiny authentication: \code{\link{gar_shiny_auth_url}},
  \code{\link{gar_shiny_auth}},
  \code{\link{gar_shiny_login_ui}},
  \code{\link{silent_auth}}
}
\author{
Based on a gist by Joe Cheng, RStudio
}
