% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps.R
\name{cr_buildstep_edit}
\alias{cr_buildstep_edit}
\title{Modify an existing buildstep with new parameters}
\usage{
cr_buildstep_edit(x, ...)
}
\arguments{
\item{x}{A buildstep created previously}

\item{...}{
  Arguments passed on to \code{\link[=cr_buildstep]{cr_buildstep}}
  \describe{
    \item{\code{name}}{name of docker image to call appended to \code{prefix}}
    \item{\code{args}}{character vector of arguments}
    \item{\code{prefix}}{prefixed to name - set to "" to suppress.  Will be suppressed if \code{name} starts with gcr.io or \code{*-docker.pkg.dev}}
    \item{\code{entrypoint}}{change the entrypoint for the docker container}
    \item{\code{dir}}{The directory to use, relative to /workspace e.g. /workspace/deploy/}
    \item{\code{id}}{Optional id for the step}
    \item{\code{env}}{Environment variables for this step.  A character vector for each assignment}
    \item{\code{volumes}}{volumes to connect and write to}
    \item{\code{waitFor}}{Whether to wait for previous buildsteps to complete before running.  Default it will wait for previous step.}
    \item{\code{secretEnv}}{A list of secrets stored in Secret Manager referred to in args via a \code{$$var}}
  }}
}
\description{
Useful for editing existing buildsteps
}
\examples{
package_build <- system.file("cloudbuild/cloudbuild.yaml",
  package = "googleCloudRunner"
)
build <- cr_build_make(package_build)
build
cr_buildstep_extract(build, step = 1)
cr_buildstep_extract(build, step = 2)

edit_me <- cr_buildstep_extract(build, step = 2)
cr_buildstep_edit(edit_me, name = "blah")
cr_buildstep_edit(edit_me, name = "gcr.io/blah")
cr_buildstep_edit(edit_me, args = c("blah1", "blah2"), dir = "meh")

# to edit multiple buildsteps at once
bs <- c(cr_buildstep_extract(build, 1), cr_buildstep_extract(build, 2))
lapply(bs, function(x) cr_buildstep_edit(list(x), dir = "blah")[[1]])
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_packagetests}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep_targets}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
