% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_mailgun}
\alias{cr_buildstep_mailgun}
\title{Send an email in a Cloud Build step via MailGun.org}
\usage{
cr_buildstep_mailgun(
  message,
  to,
  subject,
  from,
  mailgun_url = "$_MAILGUN_URL",
  mailgun_key = "$_MAILGUN_KEY",
  ...
)
}
\arguments{
\item{message}{The message markdown}

\item{to}{to email}

\item{subject}{subject email}

\item{from}{from email}

\item{mailgun_url}{The Mailgun API base URL. Default assumes you set this in \link{Build} substitution macros}

\item{mailgun_key}{The Mailgun API key.  Default assumes you set this in \link{Build} substitution macros}

\item{...}{Other arguments passed to \link{cr_buildstep_r}}
}
\description{
This uses Mailgun to send emails.  It calls an R script that posts the message to MailGuns API.
}
\details{
Requires an account at Mailgun: https://mailgun.com
Pre-verification you can only send to a whitelist of emails you configure - see Mailgun website for details.
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
mailgun_url <- "https://api.mailgun.net/v3/sandboxXXX.mailgun.org"
mailgun_key <- "key-XXXX"
\dontrun{
# assumes you have verified the email
cr_build(
  cr_build_yaml(
    steps = cr_buildstep_mailgun(
      "Hello from Cloud Build",
      to = "me@verfied_email.com",
      subject = "Hello",
      from = "googleCloudRunner@example.com"
    ),
    substitutions = list(
      `_MAILGUN_URL` = mailgun_url,
      `_MAILGUN_KEY` = mailgun_key
    )
  )
)
}
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_packagetests}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep_targets}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
