% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{cr_schedule_run}
\alias{cr_schedule_run}
\title{Forces a job to run now.}
\usage{
cr_schedule_run(x, region = cr_region_get(), projectId = cr_project_get())
}
\arguments{
\item{x}{The name of the scheduled job or a \link{Job} object}

\item{region}{The region to run within}

\item{projectId}{The projectId}
}
\description{
When this method is called, Cloud Scheduler will dispatch the job, even if the job is already running.
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_schedule_run("cloud-build-test1")
}
}
\seealso{
\href{https://cloud.google.com/scheduler/docs/reference/rest/v1/projects.locations.jobs/run}{cloudscheduler.projects.locations.jobs.run}

Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{Job}()},
\code{\link{PubsubTarget}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_run_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_pause}()}
}
\concept{Cloud Scheduler functions}
