% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_auth.R
\name{gs4_auth_configure}
\alias{gs4_auth_configure}
\alias{gs4_api_key}
\alias{gs4_oauth_app}
\title{Edit and view auth configuration}
\usage{
gs4_auth_configure(app, path, api_key)

gs4_api_key()

gs4_oauth_app()
}
\arguments{
\item{app}{OAuth app, in the sense of \code{\link[httr:oauth_app]{httr::oauth_app()}}.}

\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{api_key}{API key.}
}
\value{
\itemize{
\item \code{gs4_auth_configure()}: An object of R6 class
\link[gargle:AuthState]{gargle::AuthState}, invisibly.
\item \code{gs4_oauth_app()}: the current user-configured
\code{\link[httr:oauth_app]{httr::oauth_app()}}.
\item \code{gs4_api_key()}: the current user-configured API key.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=gs4_auth]{gs4_auth()}} does. \code{gs4_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth app, which is used when obtaining a user token.
\item API key. If googlesheets4 is de-authorized via \code{\link[=gs4_deauth]{gs4_deauth()}}, all
requests are sent with an API key in lieu of a token.
See the vignette
\href{https://gargle.r-lib.org/articles/get-api-credentials.html}{How to get your own API credentials}
for more.
If the user does not configure these settings, internal defaults
are used.
\code{gs4_oauth_app()} and \code{gs4_api_key()} retrieve the
currently configured OAuth app and API key, respectively.
}
}
\examples{
# see and store the current user-configured OAuth app (probaby `NULL`)
(original_app <- gs4_oauth_app())

# see and store the current user-configured API key (probaby `NULL`)
(original_api_key <- gs4_api_key())

if (require(httr)) {
  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "YOUR_CLIENT_ID_GOES_HERE",
    secret = "YOUR_SECRET_GOES_HERE"
  )
  google_key <- "YOUR_API_KEY"
  gs4_auth_configure(app = google_app, api_key = google_key)

  # confirm the changes
  gs4_oauth_app()
  gs4_api_key()

  # bring your own app via JSON downloaded from Google Developers Console
  # this file has the same structure as the JSON from Google
  app_path <- system.file(
    "extdata", "fake-oauth-client-id-and-secret.json",
    package = "googlesheets4"
  )
  gs4_auth_configure(path = app_path)

  # confirm the changes
  gs4_oauth_app()
}

# restore original auth config
gs4_auth_configure(app = original_app, api_key = original_api_key)
}
\seealso{
Other auth functions: 
\code{\link{gs4_auth}()},
\code{\link{gs4_deauth}()}
}
\concept{auth functions}
