% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{fitGPModel}
\alias{fitGPModel}
\title{Fits a \code{GPModel}}
\usage{
fitGPModel(group_data = NULL, group_rand_coef_data = NULL,
  ind_effect_group_rand_coef = NULL, gp_coords = NULL,
  gp_rand_coef_data = NULL, cov_function = "exponential",
  cov_fct_shape = 0, vecchia_approx = FALSE, num_neighbors = 30L,
  vecchia_ordering = "none",
  vecchia_pred_type = "order_obs_first_cond_obs_only",
  num_neighbors_pred = num_neighbors, cluster_ids = NULL,
  free_raw_data = FALSE, likelihood = "gaussian", y, X = NULL,
  params = list())
}
\arguments{
\item{group_data}{A \code{vector} or \code{matrix} with labels of group levels for grouped random effects}

\item{group_rand_coef_data}{A \code{vector} or \code{matrix} with covariate data for grouped random coefficients}

\item{ind_effect_group_rand_coef}{A \code{vector} with indices that relate every random coefficients 
to a "base" intercept grouped random effect. Counting starts at 1.}

\item{gp_coords}{A \code{matrix} with coordinates (features) for Gaussian process}

\item{gp_rand_coef_data}{A \code{vector} or \code{matrix} with covariate data for Gaussian process random coefficients}

\item{cov_function}{A \code{string} specifying the covariance function for the Gaussian process. 
The following covariance functions are available: "exponential", "gaussian", "matern", and "powered_exponential". 
We follow the notation and parametrization of Diggle and Ribeiro (2007) except for the Matern covariance 
where we follow Rassmusen and Williams (2006)}

\item{cov_fct_shape}{A \code{numeric} specifying the shape parameter of a covariance function 
(=smoothness parameter for Matern covariance, irrelevant for some covariance functions 
such as the exponential or Gaussian)}

\item{vecchia_approx}{A \code{boolean}. If true, the Vecchia approximation is used}

\item{num_neighbors}{An \code{integer} specifying the number of neighbors for the Vecchia approximation}

\item{vecchia_ordering}{A \code{string} specifying the ordering used in the Vecchia approximation. 
"none" means the default ordering is used, "random" uses a random ordering}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions. 
"order_obs_first_cond_obs_only" = observed data is ordered first and the neighbors are only observed points, 
"order_obs_first_cond_all" = observed data is ordered first and the neighbors are selected among all points 
(observed + predicted), "order_pred_first" = predicted data is ordered first for making predictions, 
"latent_order_obs_first_cond_obs_only" = Vecchia approximation for the latent process and observed data is 
ordered first and neighbors are only observed points, "latent_order_obs_first_cond_all" = Vecchia approximation 
for the latent process and observed data is ordered first and neighbors are selected among all points}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for the Vecchia approximation 
for making predictions}

\item{cluster_ids}{A \code{vector} with IDs / labels indicating independent realizations of 
random effects / Gaussian processes (same values = same process realization)}

\item{free_raw_data}{If TRUE, the data (groups, coordinates, covariate data for random coefficients) 
is freed in R after initialization}

\item{likelihood}{A \code{string} specifying the likelihood function (distribution) of the response variable
Default = "gaussian"}

\item{y}{A \code{vector} with response variable data}

\item{X}{A \code{matrix} with covariate data for fixed effects ( = linear regression term)}

\item{params}{A \code{list} with parameters for the model fitting / optimization
 \itemize{
    \item{optimizer_cov}{ Optimizer used for estimating covariance parameters. 
    Options: "gradient_descent" or "fisher_scoring". Default="fisher_scoring" for Gaussian data
    and "gradient_descent" for other likelihoods.}
    \item{optimizer_coef}{ Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent" or "wls". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance paramters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    Default="wls" for Gaussian data and "gradient_descent" for other likelihoods.}
    \item{maxit}{ Maximal number of iterations for optimization algorithm. Default=1000.}
    \item{delta_rel_conv}{ Convergence criterion: stop optimization if relative change 
    in parameters is below this value. Default=1E-6.}
    \item{init_coef}{ Initial values for the regression coefficients (if there are any, can be NULL).
    Default=NULL.}
    \item{init_cov_pars}{ Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). Default=NULL.}
    \item{lr_coef}{ Learning rate for fixed effect regression coefficients if gradient descent is used.
    Default=0.1.}
    \item{lr_cov}{ Learning rate for covariance parameters. If <= 0, internal default values are used.
    Default value = 0.1 for "gradient_descent" and 1. for "fisher_scoring"}
    \item{use_nesterov_acc}{ If TRUE Nesterov acceleration is used.
    This is used only for gradient descent. Default=TRUE}
    \item{acc_rate_coef}{ Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration. Default=0.5.}
    \item{acc_rate_cov}{ Acceleration rate for covariance parameters for Nesterov acceleration.
    Default=0.5.}
    \item{momentum_offset}{ Number of iterations for which no mometum is applied in the beginning.
    Default=2.}
    \item{trace}{ If TRUE, the value of the gradient is printed for some iterations.
    Useful for finding good learning rates. Default=FALSE.}
    \item{convergence_criterion}{ The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" (default) or "relative_change_in_parameters".}
    \item{std_dev}{ If TRUE, (asymptotic) standard deviations are calculated for the covariance parameters}
}}
}
\value{
A fitted \code{GPModel}
}
\description{
Estimates the parameters of a \code{GPModel} using maximum likelihood estimation
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

library(gpboost)
data(GPBoost_data, package = "gpboost")

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- fitGPModel(group_data = group_data[,1], y = y, likelihood="gaussian",
                       params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_var = TRUE)
pred$mu # Predicted mean
pred$var # Predicted variances
# Also predict covariance matrix
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_cov_mat = TRUE)
pred$mu # Predicted mean
pred$cov # Predicted covariance


\donttest{
#--------------------Mixed effects model: random effects and linear fixed effects----------------
X1 <- cbind(rep(1,length(y)),X) # Add intercept column
gp_model <- fitGPModel(group_data = group_data[,1], likelihood="gaussian",
                       y = y, X = X1, params = list(std_dev = TRUE))
summary(gp_model)


#--------------------Two crossed random effects and a random slope----------------
gp_model <- fitGPModel(group_data = group_data, likelihood="gaussian",
                       group_rand_coef_data = X[,2],
                       ind_effect_group_rand_coef = 1,
                       y = y, params = list(std_dev = TRUE))
summary(gp_model)


#--------------------Gaussian process model----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "exponential",
                       likelihood="gaussian", y = y, params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, gp_coords_pred = coords_test, predict_cov_mat = TRUE)
# Predicted (posterior/conditional) mean of GP
pred$mu
# Predicted (posterior/conditional) covariance matrix of GP
pred$cov


#--------------------Gaussian process model with linear mean function----------------
X1 <- cbind(rep(1,length(y)),X) # Add intercept column
gp_model <- fitGPModel(gp_coords = coords, cov_function = "exponential",
                       likelihood="gaussian", y = y, X=X1, params = list(std_dev = TRUE))
summary(gp_model)


#--------------------Gaussian process model with Vecchia approximation----------------
gp_model <- fitGPModel(gp_coords = coords, cov_function = "exponential",
                       vecchia_approx = TRUE, num_neighbors = 30,
                       likelihood="gaussian", y = y)
summary(gp_model)


#--------------------Gaussian process model with random coefficents----------------
gp_model <- GPModel(gp_coords = coords, cov_function = "exponential",
                    gp_rand_coef_data = X[,2], likelihood = "gaussian")
fit(gp_model, y = y, params = list(std_dev = TRUE))
summary(gp_model)
# Alternatively, define and fit model directly using fitGPModel
gp_model <- fitGPModel(gp_coords = coords, cov_function = "exponential",
                       gp_rand_coef_data = X[,2], y=y,
                       likelihood = "gaussian", params = list(std_dev = TRUE))
summary(gp_model)


#--------------------Combine Gaussian process with grouped random effects----------------
gp_model <- fitGPModel(group_data = group_data,
                       gp_coords = coords, cov_function = "exponential",
                       likelihood = "gaussian", y = y, params = list(std_dev = TRUE))
summary(gp_model)
}

}
