% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Dataset.R
\name{gpb.Dataset.create.valid}
\alias{gpb.Dataset.create.valid}
\title{Construct validation data}
\usage{
gpb.Dataset.create.valid(dataset, data, info = list(), ...)
}
\arguments{
\item{dataset}{\code{gpb.Dataset} object, training data}

\item{data}{a \code{matrix} object, a \code{dgCMatrix} object or a character representing a filename}

\item{info}{a list of information of the \code{gpb.Dataset} object}

\item{...}{other information to pass to \code{info}.}
}
\value{
constructed dataset
}
\description{
Construct validation data according to training data
}
\examples{
\donttest{
data(agaricus.train, package = "gpboost")
train <- agaricus.train
dtrain <- gpb.Dataset(train$data, label = train$label)
data(agaricus.test, package = "gpboost")
test <- agaricus.test
dtest <- gpb.Dataset.create.valid(dtrain, test$data, label = test$label)
}
}
