% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpt_queries.R
\name{gpt_create}
\alias{gpt_create}
\title{Use GPT to improve text}
\usage{
gpt_create(
  model,
  temperature,
  max_tokens = getOption("gptstudio.max_tokens"),
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  append_text = TRUE
)
}
\arguments{
\item{model}{The name of the GPT model to use.}

\item{temperature}{A parameter for controlling the randomness of the GPT
model's output.}

\item{max_tokens}{Maximum number of tokens to return (related to length of
response), defaults to 500}

\item{openai_api_key}{An API key for the OpenAI API.}

\item{append_text}{Add text to selection rather than replace, default to TRUE}
}
\value{
Nothing is returned. The improved text is inserted into the current
RStudio session.
}
\description{
This function uses the GPT model from OpenAI to improve the spelling and
grammar of the selected text in the current RStudio session.
}
\examples{
# Call the function as an RStudio addin
\dontrun{
gpt_create(
  model = "text-davinci-002",
  temperature = 0.5,
  max_tokens = 100,
  openai_api_key = "my_api_key"
)
}
}
