% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.SupportFunctions.R
\name{minmaxScaling}
\alias{minmaxScaling}
\title{The Min-Max Feature Scaling Function}
\usage{
minmaxScaling(dataSet)
}
\arguments{
\item{dataSet}{a data.frame that representing dataset (\eqn{m \times n}), 
where \eqn{m} is the number of instances and \eqn{n} is the number 
of variables where the last column is the output variable. dataSet 
must have at least two columns and ten rows of data that contain 
only numbers (integer or float).}
}
\value{
a list contains feature scaled dataset and scaling parameter
}
\description{
A function to do feature scaling to dataset with min-max scaling method.
}
\details{
This function changes the value of dataset that represented by data.frame
object into min-max scaled value that has interval between 0 to 1.
}
\examples{
 
################################## 
## Feature scaling with Min-Max Scaling Method
## load R Package data  
data(gradDescentRData)
## get z-factor Data
dataSet <- gradDescentRData$CompressilbilityFactor
## do min-max scaling to dataset
featureScalingResult <- minmaxScaling(dataSet)
## show result
print(featureScalingResult$scaledDataSet)
print(featureScalingResult$scalingParameter)

}
\seealso{
\code{\link{minmaxDescaling}}
}
