% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.R
\name{hydrate}
\alias{hydrate}
\title{Create a grafzahl S3 object from the output_dir}
\usage{
hydrate(output_dir, model_type = NULL, regression = FALSE)
}
\arguments{
\item{output_dir}{string, location of the output model. If missing, the model will be stored in a temporary directory. Important: Please note that if this directory exists, it will be overwritten.}

\item{model_type}{a string indicating model_type of the input model. If \code{NULL}, it will be inferred from \code{model_name}. It can only be one of the following: "albert", "bert", "bertweet", "bigbird", "camembert", "deberta", "distilbert", "electra", "flaubert", "herbert", "layoutlm", "layoutlmv2", "longformer", "mpnet", "mobilebert", "rembert", "roberta", "squeezebert", "squeezebert", "xlm", "xlmroberta", "xlnet". This will be lowercased and hyphens will be removed, e.g. "XLM-RoBERTa" will be normalized to "xlmroberta".}

\item{regression}{logical, if \code{TRUE}, the task is regression, classification otherwise.}
}
\value{
a \code{grafzahl} S3 object with the following items
\item{call}{original function call}
\item{input_data}{input_data for the underlying python function}
\item{output_dir}{location of the output model}
\item{model_type}{model type}
\item{model_name}{model name}
\item{regression}{whether or not it is a regression model}
\item{levels}{factor levels of y}
\item{manual_seed}{random seed}
\item{meta}{metadata about the current session}
}
\description{
Create a grafzahl S3 object from the output_dir
}
