% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_transformations.R
\name{Gamma2graph}
\alias{Gamma2graph}
\alias{Sigma2graph}
\alias{Theta2graph}
\alias{partialMatrixToGraph}
\title{Convert matrix to graph}
\usage{
Gamma2graph(Gamma, tol = get_large_tol(), check = TRUE)

Sigma2graph(Sigma, tol = get_large_tol(), k = NULL, full = FALSE, check = TRUE)

Theta2graph(Theta, tol = get_large_tol(), k = NULL, full = FALSE, check = TRUE)

partialMatrixToGraph(M)
}
\arguments{
\item{Gamma}{Numeric \dxd variogram matrix.}

\item{tol}{Numeric scalar. Entries in the precision matrix with absolute value
smaller than this are considered to be zero.}

\item{check}{Whether to check the inputs and call \code{ensure_matrix_symmetry_and_truncate_zeros}
on the outputs.}

\item{Sigma}{Numeric \dxd or \d1xd1 covariance matrix.}

\item{k}{\code{NULL} if the input/output matrix is \eSigma/\eTheta.
Else, an integer between 1 and d indicating the value of k in \eSigmaK, \eThetaK.}

\item{full}{Logical. If \code{TRUE} and \code{!is.null(k)},
the input/output matrix is a \dxd matrix with the kth row filled with zeros.}

\item{Theta}{Numeric \dxd or \d1xd1 precision matrix.}

\item{M}{Partial matrix with \code{NA} entries indicating missing edges.}
}
\value{
An \code{\link[igraph:make_graph]{igraph::graph}} object.
}
\description{
Creates a graph object representing the graph structure implied by a parameter matrix.
}
\seealso{
Other parameter matrix transformations:
\code{\link{Gamma2Sigma}()},
\code{\link{chi2Gamma}()},
\code{\link{par2Matrix}()}
}
\concept{matrixTransformations}
