% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/year.R
\name{as_year}
\alias{as_year}
\alias{as_year.default}
\alias{as_year.Date}
\alias{as_year.POSIXt}
\alias{as_year.character}
\alias{as_year.factor}
\title{Coerce an object to year-quarter}
\usage{
as_year(x, ...)

\method{as_year}{default}(x, ...)

\method{as_year}{Date}(x, ...)

\method{as_year}{POSIXt}(x, ...)

\method{as_year}{character}(x, ...)

\method{as_year}{factor}(x, ...)
}
\arguments{
\item{x}{\R object.

Character input is first parsed using \code{as.Date()}.

POSIXct and POSIXlt are converted with the timezone respected.}

\item{...}{Only used For character input where additional arguments are passed through
to \code{as.Date()}.}
}
\value{
A \verb{<grates_year>} object.
}
\description{
\code{as_year()} is a generic for coercing input in to \verb{<grates_year>}.
}
\examples{
as_year(Sys.Date())
as_year(as.POSIXct("2019-03-04 01:01:01", tz = "America/New_York"), interval = 2)
as_year("2019-05-03")

}
\seealso{
\code{as.Date()}
}
