% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{c.ts}
\alias{c.ts}
\title{Combine two time series in one}
\usage{
\method{c}{ts}(...)
}
\arguments{
\item{...}{The ts vectors to combine.}
}
\value{
This function returns the ts vector.
}
\description{
The function combines several ts vectors in one, maintaining the structure
of the time series
}
\details{
The function will combine ts objects in a ts vector, using the frequency and the start of
the first one. So, if you combine several time series, they will be stacked one after
another.
}
\examples{

x <- ts(rnorm(120,100,10), frequency=12)
x1 <- window(x, 1, 8+11/12)
x2 <- window(x, 9)
c(x1,x2)
c(x2,x1)

}
\seealso{
\link[base]{c}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{htest}
