% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_input_df.R
\name{validate_input_df}
\alias{validate_input_df}
\title{Validate Input DataFrame}
\usage{
validate_input_df(input_df, distribution)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str) and various other columns
depending on the distribution type. See vignette for more details.}

\item{distribution}{String of the distribution name}
}
\value{
Bool TRUE if all checks pass.
}
\description{
Validates the input dataframe has the correct type, correct required column names,
that the distribution is valid, that the column types are correct, and that the
column values are greater than or equal to 0 when they are numeric.
}
\examples{
input_df <- tibble::tibble(
   option_name = c("A", "B"),
   sum_clicks = c(1000, 1000),
   sum_conversions = c(100, 120)
)
validate_input_df(input_df, "conversion_rate")

}
