% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_functions.R
\name{get_end_of_cutting_season}
\alias{get_end_of_cutting_season}
\title{Last day of cutting season}
\usage{
get_end_of_cutting_season(min_biomass, elevation, intensity = "high")
}
\arguments{
\item{min_biomass}{float A standing biomass below this value cannot even
be harvested,}

\item{elevation}{float Altitude in m.a.s.l.}

\item{intensity}{string Management intensity. One of "high", "middle", "low"}
}
\value{
float Last (fractional) day of the year on which a cut still makes
sense.
}
\description{
Estimate the last day on which it still makes sense to cut. This is done
by checking at which point the expected target biomass (see
\code{\link[=get_relative_cut_contribution]{get_relative_cut_contribution()}}) goes below the minimally harvestable
standing biomass.
}
\examples{
get_end_of_cutting_season(50, 1200)
get_end_of_cutting_season(50, 1200, intensity = "low")

}
\seealso{
\code{\link[=get_relative_cut_contribution]{get_relative_cut_contribution()}}
}
