% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_scan.R
\name{analyze_parameter_scan}
\alias{analyze_parameter_scan}
\title{Analyze results of a parameter scan}
\usage{
analyze_parameter_scan(
  parameter_scan_results,
  datafile = "",
  smooth_interval = 28
)
}
\arguments{
\item{parameter_scan_results}{String or List. If a string, it is
interpreted as the name of a \code{rds} file that contains the results of a
parameter scan which is then loaded using \code{\link[=readRDS]{readRDS()}}. Otherwise, it
should be the output of \code{\link[=run_parameter_scan]{run_parameter_scan()}} directly.}

\item{datafile}{Name or path to a file containing measured data. The model
results in \emph{parameter_scan_results} are compared to the data therein. If
empty, the site is inferred from the \link{ModvegeSite} objects in
\emph{parameter_scan_results} and a corresponding data file is searched for
in `getOption("growR.data_dir", default = "data").}

\item{smooth_interval}{Int. Number of days over which the variable \code{dBM}
is smoothened. Should be set to make experimental data and simulated
data to be as comparable as possible.}
}
\value{
analyzed A list with five keys: \code{dBM}, \code{cBM}, \code{cBM_end}, \code{metrics}
and \code{params}.
\describe{
\item{dBM}{A data.frame with \code{1 + n_params + n_metrics} columns
where each row represents a different parameter combination.
The first column (\code{n}) gives the row number and is used to identify a
parameter combination. The subsequent \code{n_params} columns give the
values of the parameters used in this combination. The final \code{n_metrics}
columns give the resulting performance score of the model run with
these parameters for each metric applied to model variable \code{dBM}.}
\item{cBM}{A data.frame of same format as for the key \emph{dBM}. The first
\code{n_params + 1} columns are identical to the data.frame in \emph{dBM}. The
difference is that the final \code{n_metrics} columns give performance
scores with respect to the model variable \code{cBM}.}
\item{cBM_end}{A data.frame analogous to \emph{dBM} and \emph{cBM}, only this time
the last \code{n_metrics} columns give performance scores with respect to
the variable \code{cBM_end}, which is the final value of \code{cBM}, i.e. the
cumulative grown biomass at the end of the year.}
\item{params}{A vector containing the names of the scanned parameters.
These are also the column names of columns \code{2:(n_params+1)} in
\emph{results}.}
\item{metrics}{A vector containing the names of the employed
performance metrics. These are also the column names of the last
\code{n_metrics} columns in \emph{results}.}
}
}
\description{
Analyze results of a parameter scan
}
\examples{
# There needs to be data available with which the model is to be compared.
# For this example, use data provided by the package.
path = system.file("extdata", package = "growR")
datafile = file.path(path, "posieux1.csv")

# We also use example parameter scan data provided by the package.
# In the real world, you would generally create your own data using 
# `run_parameter_scan()`.
analyze_parameter_scan(parameter_scan_example, datafile = datafile)

}
\seealso{
\code{\link[=run_parameter_scan]{run_parameter_scan()}}, \code{\link[=readRDS]{readRDS()}}
}
