% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expected_time.R
\name{expected_time}
\alias{expected_time}
\title{Predict time at which a targeted event count is achieved}
\usage{
expected_time(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9) * 5),
  fail_rate = define_fail_rate(stratum = "All", duration = c(3, 100), fail_rate =
    log(2)/c(9, 18), hr = c(0.9, 0.6), dropout_rate = rep(0.001, 2)),
  target_event = 150,
  ratio = 1,
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{An \code{enroll_rate} data frame with or without stratum
created by \code{\link[=define_enroll_rate]{define_enroll_rate()}}.}

\item{fail_rate}{A \code{fail_rate} data frame with or without stratum
created by \code{\link[=define_fail_rate]{define_fail_rate()}}.}

\item{target_event}{The targeted number of events to be achieved.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to \code{target_event}.}
}
\value{
A tibble with \code{Time} (computed to match events in \code{target_event}),
\code{AHR} (average hazard ratio), \code{Events} (\code{target_event} input),
\code{info} (information under given scenarios), and \code{info0}
(information under related null hypothesis) for each value of
\code{total_duration} input.
}
\description{
\code{expected_time()} is made to match input format with \code{\link[=ahr]{ahr()}} and to solve for the
time at which the expected accumulated events is equal to an input target.
Enrollment and failure rate distributions are specified as follows.
The piecewise exponential distribution allows a simple method to specify a distribution
and enrollment pattern
where the enrollment, failure and dropout rates changes over time.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Use root-finding routine with `AHR()` to find time at which targeted events accrue.
   \item Return a tibble with a single row with the output from `AHR()` got the specified output.
   }
 }
}

\examples{
# ------------------------#
#      Example 1          #
# ------------------------#
# default
\donttest{
expected_time()
}

# ------------------------#
#      Example 2          #
# ------------------------#
# check that result matches a finding using AHR()
# Start by deriving an expected event count
enroll_rate <- define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9) * 5)
fail_rate <- define_fail_rate(
  duration = c(3, 100),
  fail_rate = log(2) / c(9, 18),
  hr = c(.9, .6),
  dropout_rate = .001
)
total_duration <- 20
xx <- ahr(enroll_rate, fail_rate, total_duration)
xx

# Next we check that the function confirms the timing of the final analysis.
\donttest{
expected_time(enroll_rate, fail_rate,
  target_event = xx$event, interval = c(.5, 1.5) * xx$time
)
}
}
