% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_info_ahr.R
\name{gs_info_ahr}
\alias{gs_info_ahr}
\title{Information and effect size based on AHR approximation}
\usage{
gs_info_ahr(
  enroll_rate = define_enroll_rate(duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = define_fail_rate(duration = c(3, 100), fail_rate = log(2)/c(9, 18), hr =
    c(0.9, 0.6), dropout_rate = 0.001),
  ratio = 1,
  event = NULL,
  analysis_time = NULL,
  interval = c(0.01, 100)
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{ratio}{Experimental:Control randomization ratio.}

\item{event}{Targeted minimum events at each analysis.}

\item{analysis_time}{Targeted minimum study duration at each analysis.}

\item{interval}{An interval that is presumed to include the time at which
expected event count is equal to targeted event.}
}
\value{
A data frame with columns Analysis, Time, AHR, Events, theta, info, info0.
\code{info}, and \code{info0} contain statistical information under H1, H0, respectively.
For analysis \code{k}, \code{Time[k]} is the maximum of \code{analysis_time[k]} and the
expected time required to accrue the targeted \code{event[k]}.
\code{AHR} is the expected average hazard ratio at each analysis.
}
\description{
Based on piecewise enrollment rate, failure rate, and dropout rates computes
approximate information and effect size using an average hazard ratio model.
}
\details{
The \code{\link[=ahr]{ahr()}} function computes statistical information at targeted
event times. The \code{\link[=expected_time]{expected_time()}} function is used to get events and
average HR at targeted \code{analysis_time}.
}
\section{Specification}{

\if{latex}{
 \itemize{
   \item Validate if input event is a numeric value vector or a vector with increasing values.
   \item Validate if input analysis_time is a numeric value vector or a vector with increasing values.
   \item Validate if inputs event and analysis_time have the same length if they are both specified.
   \item Compute average hazard ratio:
   \itemize{
     \item If analysis_time is specified, calculate average hazard ratio using \code{AHR()}.
     \item If event is specified, calculate average hazard ratio using \code{expected_time()}.
   }
   \item Return a data frame of Analysis, Time, AHR, Events, theta, info, info0.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
library(gsDesign)
library(gsDesign2)

# Example 1 ----
\donttest{
# Only put in targeted events
gs_info_ahr(event = c(30, 40, 50))
}
# Example 2 ----

# Only put in targeted analysis times
gs_info_ahr(analysis_time = c(18, 27, 36))

# Example 3 ----
\donttest{
# Some analysis times after time at which targeted event accrue
# Check that both Time >= input analysis_time and event >= input event
gs_info_ahr(event = c(30, 40, 50), analysis_time = c(16, 19, 26))
gs_info_ahr(event = c(30, 40, 50), analysis_time = c(14, 20, 24))
}
}
