% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_nb.R
\name{design_nb}
\alias{design_nb}
\title{Clinical trials with negative binomial outcomes}
\usage{
design_nb(rate1, rate2, dispersion, power, ratio_H0 = 1, sig_level,
  random_ratio = 1, t_recruit1 = NULL, t_recruit2 = NULL,
  study_period = NULL, accrual_period = NULL, followup_max = NULL)
}
\arguments{
\item{rate1}{numeric; assumed rate of treatment group 1 in the alternative}

\item{rate2}{numeric; assumed rate of treatment group 2 in the alternative}

\item{dispersion}{numeric; dispersion (shape) parameter of negative binomial distribution}

\item{power}{numeric; target power}

\item{ratio_H0}{numeric; positive number denoting the rate ratio rate_1/rate_2
under the null hypothesis, i.e. the non-inferiority or superiority margin}

\item{sig_level}{numeric; Type I error / significance level}

\item{random_ratio}{numeric; randomization ratio n1/n2}

\item{t_recruit1}{numeric vector; recruit (i.e. study entry) times in group 1}

\item{t_recruit2}{numeric vector; recruit (i.e. study entry) times in group 2}

\item{study_period}{numeric; study duration}

\item{accrual_period}{numeric; accrual period}

\item{followup_max}{numeric; maximum exposure time of a patient}
}
\value{
A list containing the following components:
\item{rate1}{as input}
\item{rate2}{as input}
\item{dispersion}{as input}
\item{power}{as input}
\item{ratio_H0}{as input}
\item{ratio_H1}{ratio \code{rate1}/\code{rate2}}
\item{sig_level}{as input}
\item{random_ratio}{as input}
\item{t_recruit1}{as input}
\item{t_recruit2}{as input}
\item{study_period}{as input}
\item{followup_max}{as input}
\item{max_info}{maximum information}
}
\description{
Design a clinical trial with negative binomial outcomes
}
\examples{
# Calculate sample size for given accrual period and study duration assuming uniformal accrual
out <- design_nb(rate1 = 0.0875, rate2 = 0.125, dispersion = 5, power = 0.8,
                 ratio_H0 = 1, sig_level = 0.025,
                 study_period = 4, accrual_period = 1, random_ratio = 2)
out

# Calculate sample size for a fixed exposure time of 0.5 years
out <- design_nb(rate1 = 4.2, rate2 = 8.4, dispersion = 3, power = 0.8,
                 ratio_H0 = 1, sig_level = 0.025,
                 followup_max = 0.5, random_ratio = 2)
out

# Calculate study period for given recruitment time
t_recruit1 <- seq(0, 1.25, length.out = 1200)
t_recruit2 <- seq(0, 1.25, length.out = 800)
out <- design_nb(rate1 = 0.0875, rate2 = 0.125, dispersion = 5, power = 0.8,
                 ratio_H0 = 1, sig_level = 0.025,
                 t_recruit1 = t_recruit1, t_recruit2 = t_recruit2)
}
