% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttap.R
\name{buttap}
\alias{buttap}
\title{Butterworth filter prototype}
\usage{
buttap(n)
}
\arguments{
\item{n}{Order of the filter.}
}
\value{
List of class \code{\link{Zpg}} containing poles and gain of the
  filter.
}
\description{
Return the poles and gain of an analog Butterworth lowpass filter prototype.
}
\details{
This function exists for compatibility with 'Matlab' and 'Octave' only, and
is equivalent to \code{butter(n, 1, "low", "s")}.
}
\examples{
## 9th order Butterworth low-pass analog filter
zp <- buttap(9)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)

}
\author{
Carne Draug, \email{carandraug+dev@gmail.com}.\cr
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
