% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detrend.R
\name{detrend}
\alias{detrend}
\title{Remove Polynomial Trend}
\usage{
detrend(x, p = 1)
}
\arguments{
\item{x}{Input vector or matrix. If \code{x} is a matrix, the trend is
removed from the columns.}

\item{p}{Order of the polynomial. Default: 1. The order of the polynomial can
also be given as a string, in which case \code{p} must be either
\code{"constant"} (corresponds to \code{p = 0}) or \code{"linear"}
(corresponds to \code{p = 1}).}
}
\value{
The detrended data, of same type and dimensions as \code{x}
}
\description{
\code{detrend} removes the polynomial trend of order \code{p} from the data
\code{x}.
}
\examples{
t <- 0:20
x <- 3 * sin(t) + t
y <- detrend(x)
plot(t, x, type = "l", ylim = c(-5, 25), xlab = "", ylab = "")
lines(t, y, col = "red")
lines(t, x - y, lty = 2)
legend('topleft', legend = c('Input Data', 'Detrended Data', 'Trend'),
 col = c(1, 2 ,1), lty = c(1, 1, 2))

}
\author{
Kurt Hornik, \email{Kurt.Hornik@wu-wien.ac.at}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
