% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipap.R
\name{ellipap}
\alias{ellipap}
\title{Low-pass analog elliptic filter}
\usage{
ellipap(n, Rp, Rs)
}
\arguments{
\item{n}{Order of the filter.}

\item{Rp}{dB of passband ripple.}

\item{Rs}{dB of stopband ripple.}
}
\value{
list of class \code{\link{Zpg}} containing zeros, poles and gain of
  the filter.
}
\description{
Return the zeros, poles and gain of an analog elliptic low-pass filter
prototype.
}
\details{
This function exists for compatibility with 'Matlab' and 'OCtave' only, and
is equivalent to \code{ellip(n, Rp, Rs, 1, "low", "s")}.
}
\examples{
## 9th order elliptic low-pass analog filter
zp <- ellipap(9, .1, 40)
w <- seq(0, 4, length.out = 128)
freqs(zp, w)

}
\author{
Carne Draug, \email{carandraug+dev@gmail.com}.
 Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
