% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaiser.R
\name{kaiser}
\alias{kaiser}
\title{Kaiser window}
\usage{
kaiser(n, beta = 0.5)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{beta}{Shape factor, specified as a positive real scalar. The parameter
\code{beta} affects the side lobe attenuation of the Fourier transform of
the window. Default: 0.5}
}
\value{
Kaiser window, returned as a vector.
}
\description{
Return the filter coefficients of a kaiser window of length \code{n}.
}
\details{
The Kaiser, or Kaiser-Bessel, window is a simple approximation of the DPSS
window using Bessel functions, discovered by James Kaiser.
\if{latex}{
  \deqn{w(x) = \frac{besselI(0, \beta \cdot \sqrt{(1 -
  (2*x/m)^{2}))}}{besselI(0, \beta)}; -m/2 <= x <= m/2}
}
\if{html}{\preformatted{
        besselI(0, Beta * sqrt(1-(2*x/m)^2))
k(x) =  -------------------------------------,  -m/2 <= x <= m/2
        besselO(0, Beta)
}}
The variable parameter \eqn{\beta} determines the trade-off between main lobe
width and side lobe levels of the spectral leakage pattern. Increasing
\eqn{\beta} widens the main lobe and decreases the amplitude of the side
lobes (i.e., increases the attenuation).
}
\examples{

k <- kaiser(200, 2.5)
plot (k, type = "l", xlab = "Samples", ylab =" Amplitude")

}
\author{
Kurt Hornik, \email{Kurt.Hornik@ci.tuwien.ac.at},\cr Paul Kienzle,
  \email{pkienzle@users.sf.net}.\cr Conversion to R by Geert van Boxtel
  \email{G.J.M.vanBoxtel@gmail.com}.
}
