% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuttallwin.R
\name{nuttallwin}
\alias{nuttallwin}
\title{Nuttall-defined minimum 4-term Blackman-Harris window}
\usage{
nuttallwin(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric"}{(Default). Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When \code{periodic} is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Nuttall-defined Blackman-Harris window, returned as a vector.
}
\description{
Return the filter coefficients of a Blackman-Harris window defined by Nuttall
of length \code{n}.
}
\details{
The window is minimum in the sense that its maximum sidelobes are minimized.
The coefficients for this window differ from the Blackman-Harris window
coefficients computed with \code{blackmanharris} and produce slightly lower
sidelobes.
}
\examples{

n <- nuttallwin(64)
plot (n, type = "l", xlab = "Samples", ylab =" Amplitude")

}
\seealso{
\code{\link{blackman}}, \code{\link{blackmanharris}}
}
\author{
Sylvain Pelissier, \email{<sylvain.pelissier@gmail.com>}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
