% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rectwin.R
\name{rectwin}
\alias{rectwin}
\title{Rectangular window}
\usage{
rectwin(n)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}
}
\value{
rectangular window, returned as a vector.
}
\description{
Return the filter coefficients of a rectangular window of length \code{n}.
}
\details{
The output of the rectwin function with input \code{n} can also be created
using the \code{rep} function: w <- rep(1L, n)
}
\examples{

r <- rectwin(64)
plot (r, type = "l", xlab = "Samples", ylab =" Amplitude", ylim = c(0, 1))

}
\seealso{
\code{\link{boxcar}}
}
\author{
Sylvain Pelissier, \email{sylvain.pelissier@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
