% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remez.R
\name{remez}
\alias{remez}
\title{Parks-McClellan optimal FIR filter design}
\usage{
remez(
  n,
  f,
  a,
  w = rep(1, length(f)/2),
  ftype = c("bandpass", "differentiator", "hilbert"),
  density = 16
)
}
\arguments{
\item{n}{filter order (1 less than the length of the filter).}

\item{f}{normalized frequency points, strictly increasing vector in the range
[0, 1], where 1 is the Nyquist frequency. The number of elements in the
vector is always a multiple of 2.}

\item{a}{vector of desired amplitudes at the points specified in \code{f}.
\code{f} and \code{a} must be the same length. The length must be an even
number.}

\item{w}{vector of weights used to adjust the fit in each frequency band. The
length of \code{w} is half the length of \code{f} and \code{a}, so there is
exactly one weight per band. Default: 1.}

\item{ftype}{filter type, matched to one of \code{"bandpass"} (default),
\code{"differentiatior"}, or \code{"hilbert"}.}

\item{density}{determines how accurately the filter will be constructed. The
minimum value is 16 (default), but higher numbers are slower to compute.}
}
\value{
The FIR filter coefficients, a vector of length \code{n + 1}, of
  class \code{Ma}
}
\description{
Parks-McClellan optimal FIR filter design using the Remez exchange algorithm.
}
\examples{
## low pass filter
f1 <- remez(15, c(0, 0.3, 0.4, 1), c(1, 1, 0, 0))
freqz(f1)

## band pass
f <- c(0, 0.3, 0.4, 0.6, 0.7, 1)
a <- c(0, 0, 1, 1, 0, 0)
b <- remez(17, f, a)
hw <- freqz(b, 512)
plot(f, a, type = "l", xlab = "Radian Frequency (w / pi)",
     ylab = "Magnitude")
lines(hw$w/pi, abs(hw$h), col = "red")
legend("topright", legend = c("Ideal", "Remez"), lty = 1,
       col = c("black", "red"))

}
\references{
\url{https://en.wikipedia.org/wiki/Fir_filter}

Rabiner, L.R., McClellan, J.H., and Parks, T.W. (1975). FIR
  Digital Filter Design Techniques Using Weighted Chebyshev Approximations,
  IEEE Proceedings, vol. 63, pp. 595 - 610.\cr
  \url{https://en.wikipedia.org/wiki/Parks-McClellan_filter_design_algorithm}
}
\seealso{
\code{\link{Ma}}, \code{\link{filter}}, \code{\link{fftfilt}},
  \code{\link{fir1}}
}
\author{
Jake Janovetz, \email{janovetz@uiuc.edu},\cr
  Paul Kienzle, \email{pkienzle@users.sf.net},\cr
  Kai Habel, \email{kahacjde@linux.zrz.tu-berlin.de}.\cr
  Conversion to R Tom Short\cr
  adapted by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
