% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wconv.R
\name{wconv}
\alias{wconv}
\title{1-D or 2-D convolution}
\usage{
wconv(
  type = c("1d", "2d", "row", "column"),
  a,
  b,
  shape = c("full", "same", "valid")
)
}
\arguments{
\item{type}{Numeric or character, specifies the type of convolution to
  perform:
\describe{
  \item{"1d"}{For \code{a} and \code{b} as (coerced to) vectors,
  perform 1-D convolution of \code{a} and \code{b};}
  \item{"2d}{For \code{a} and \code{b} as (coerced to)
  matrices, perform 2-D convolution of \code{a} and \code{b};}
  \item{"row"}{For \code{a} as (coerced to) a matrix, and \code{b}
  (coerced to) a vector, perform the 1-D convolution of the rows of \code{a}
  and \code{b};}
  \item{"column"}{For \code{a} as (coerced to) a matrix, and \code{b}
  (coerced to) a vector, perform the 1-D convolution of the colums of
  \code{a} and \code{b};}
}}

\item{a, b}{Input vectors or matrices, coerced to numeric.}

\item{shape}{Subsection of convolution, partially matched to:
\describe{
  \item{"full"}{Return the full convolution (default)}
  \item{"same"}{Return the central part of the convolution with the same size
  as A. The central part of the convolution begins at the indices
  \code{floor(c(nrow(b), ncol(b)) / 2 + 1)}}
  \item{"valid"}{Return only the parts which do not include zero-padded edges.
  The size of the result is \code{max(c(nrow(a), ncol(b)) - c(nrow(b),
  ncol(b)) + 1, 0)}}
}}
}
\value{
Convolution of input matrices, returned as a matrix or a vector.
}
\description{
Compute the one- or two-dimensional convolution of two vectors or matrices.
}
\examples{
a <- matrix(1:16, 4, 4)
b <- matrix(1:9, 3,3)
w <- wconv('2', a, b)
w <- wconv('1', a, b, 'same')
w <- wconv('r', a, b)
w <- wconv('r', a, c(0,1), 'same')
w <- wconv('c', a, c(0,1), 'valid')

}
\seealso{
\code{\link{conv}}
}
\author{
Lukas Reichlin, \email{lukas.reichlin@gmail.com}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
