% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zp2sos.R
\name{zp2sos}
\alias{zp2sos}
\title{Zero-pole-gain to second-order section format}
\usage{
zp2sos(z, p, g = 1, order = c("down", "up"))
}
\arguments{
\item{z}{complex vector of the zeros of the model (roots of \code{B(z)})}

\item{p}{complex vector of the poles of the model (roots of \code{A(z)})}

\item{g}{overall gain (\code{B(Inf)}). Default: 1}

\item{order}{row order, specified as:
\describe{
  \item{"up"}{order the sections so the first row contains the poles farthest
  from the unit circle.}
  \item{"down" (Default)}{order the sections so the first row of \code{sos}
  contains the poles closest to the unit circle.}
}
The ordering influences round-off noise and the probability of overflow.}
}
\value{
A list with the following list elements:
\describe{
  \item{sos}{Second-order section representation, specified as an nrow-by-6
  matrix, whose rows contain the numerator and denominator coefficients of
  the second-order sections:\cr \code{sos <- rbind(cbind(B1, A1), cbind(...),
  cbind(Bn, An))}, where \code{B1 <- c(b0, b1, b2)}, and \code{A1 <- c(a0,
  a1, a2)} for section 1, etc. The b0 entry must be nonzero for each
  section.}
  \item{g}{Overall gain factor that effectively scales the output \code{b}
  vector (or any one of the input \code{Bi} vectors).}
}
}
\description{
Convert digital filter zero-pole-gain data to second-order section form.
}
\examples{
zpk <- tf2zp (c(1, 0, 0, 0, 0, 1), c(1, 0, 0, 0, 0, .9))
sosg <- zp2sos (zpk$z, zpk$p, zpk$g)

}
\seealso{
\code{\link{as.Sos}}, \code{\link{filter}}, \code{\link{sosfilt}}
}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
