% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt_symbol_first.R
\name{fmt_symbol_first}
\alias{fmt_symbol_first}
\title{Aligning first-row text only}
\usage{
fmt_symbol_first(
  gt_object,
  column = NULL,
  symbol = NULL,
  suffix = "",
  decimals = NULL,
  last_row_n = NULL,
  symbol_first = FALSE,
  scale_by = NULL,
  gfont = "Fira Mono"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{columns to apply color to with tidyeval}

\item{symbol}{The HTML code or raw character string of the symbol being inserted, optionally}

\item{suffix}{a suffix to add, optionally}

\item{decimals}{the number of decimal places to round to}

\item{last_row_n}{Defining the last row to apply this to. The function will attempt to guess the proper length, but you can always hardcode a specific length.}

\item{symbol_first}{TRUE/FALSE - symbol before after suffix.}

\item{scale_by}{A numeric value to multiply the values by. Useful for scaling percentages from 0 to 1 to 0 to 100.}

\item{gfont}{A string passed to \code{gt::google_font()} - defaults to "Fira Mono" and requires a Monospaced font for alignment purposes. Existing Google Monospaced fonts are available at: \href{https://fonts.google.com/?category=Monospace&preview.text=0123456789&preview.text_type=custom}{fonts.google.com}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
This is an experimental function that allows you to apply a suffix/symbol
to only the first row of a table, and maintain the alignment with whitespace
in the remaining rows.
}
\section{Figures}{

\if{html}{\figure{gt_fmt_first.png}{options: width=100\%}}
}

\section{Function ID}{

2-1
}

\examples{
library(gt)
fmted_tab <- gtcars \%>\%
  head() \%>\%
    dplyr::select(mfr, year, bdy_style, mpg_h, hp) \%>\%
    dplyr::mutate(mpg_h = rnorm(n = dplyr::n(), mean = 22, sd = 1)) \%>\%
    gt::gt() \%>\%
    gt::opt_table_lines() \%>\%
    fmt_symbol_first(column = mfr, symbol = "&#x24;", last_row_n = 6) \%>\%
    fmt_symbol_first(column = year, suffix = "\%") \%>\%
    fmt_symbol_first(column = mpg_h, symbol = "&#37;", decimals = 1) \%>\%
    fmt_symbol_first(hp, symbol = "&#176;", suffix = "F", symbol_first = TRUE)

}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
