% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_header.R
\name{modify_header}
\alias{modify_header}
\title{Modify column headers in gtsummary tables}
\usage{
modify_header(x, stat_by = NULL, ..., text_interpret = c("md", "html"))
}
\arguments{
\item{x}{gtsummary object, e.g. \code{tbl_summary} or \code{tbl_regression}}

\item{stat_by}{String specifying text to include above the summary statistics
stratified by a variable.  Only use with stratified \code{tbl_summary} objects.
The following fields are available for use in the
headers:
\itemize{
\item \code{{n}} number of observations in each group,
\item \code{{N}} total number of observations,
\item \code{{p}} percentage in each group,
\item \code{{level}} the 'by' variable level,
\item \code{"fisher.test"} for a Fisher's exact test,
}

Syntax follows \link[glue:glue]{glue::glue},
e.g. \code{stat_by = "**{level}**, N = {n} ({style_percent(p)\\\%})"}.
The \code{by} argument from the parent \code{tbl_summary()} cannot be \code{NULL}.}

\item{...}{Specifies column label of any other column in \code{.$table_body}.
Argument is the column name, and the value is the new column header
(e.g. \code{p.value = "Model P-values"}). Use
\code{print(x$table_body)} to see columns available.}

\item{text_interpret}{indicates whether text will be interpreted as markdown (\code{"md"})
or HTML (\code{"html"}).  The text is interpreted with the {gt} package's \code{md()} or
\code{html()} functions.  The default is \code{"md"}, and is ignored when the print engine
is not {gt}.}
}
\value{
Function return the same class of gtsummary object supplied
}
\description{
Column labels can be modified to include calculated statistics;
e.g. the N can be dynamically included by wrapping it in curly brackets
(following \link[glue:glue]{glue::glue} syntax).
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_col_ex1.png}{options: width=31\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_col_ex2.png}{options: width=50\%}}
}

\examples{
tbl_col_ex1 <-
  trial[c("age", "grade", "response")] \%>\%
  tbl_summary() \%>\%
  modify_header(stat_0 = "**All Patients**, N = {N}")

tbl_col_ex2 <-
  trial[c("age", "grade", "response", "trt")] \%>\%
  tbl_summary(by = trt) \%>\%
  modify_header(
    stat_by = "**{level}**, N = {n} ({style_percent(p, symbol = TRUE)})"
  )
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p}()},
\code{\link{add_q.tbl_summary}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_summary}()},
\code{\link{inline_text.tbl_summary}()},
\code{\link{sort_p.tbl_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_regression}()},
\code{\link{bold_p.tbl_stack}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{sort_p.tbl_regression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q.tbl_uvregression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_stack}()},
\code{\link{bold_p.tbl_uvregression}()},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{sort_p.tbl_uvregression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}

Other tbl_survival tools: 
\code{\link{inline_text.tbl_survival}()},
\code{\link{tbl_survival.survfit}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_survival tools}
\concept{tbl_uvregression tools}
