% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_header.R
\name{modify_header}
\alias{modify_header}
\title{Modify column headers in gtsummary tables}
\usage{
modify_header(
  x,
  update = NULL,
  stat_by = NULL,
  text_interpret = c("md", "html"),
  ...
)
}
\arguments{
\item{x}{gtsummary object, e.g. \code{tbl_summary} or \code{tbl_regression}}

\item{update}{list of formulas or a single formula specifying the updated
column label. Columns from \code{x$table_body} may be selected.}

\item{stat_by}{Used with \code{tbl_summary(by=)} objects with a \verb{by=} argument.
String specifying text to include above the summary statistics.
The following fields are available for use in the
headers:
\itemize{
\item \code{{n}} number of observations in each group,
\item \code{{N}} total number of observations,
\item \code{{p}} percentage in each group,
\item \code{{level}} the 'by' variable level,
}

Syntax follows \code{\link[glue:glue]{glue::glue()}},
e.g. \code{stat_by = "**{level}**, N = {n} ({style_percent(p)}\%)"}.}

\item{text_interpret}{String indicates whether text will be interpreted with
\code{\link[gt:md]{gt::md()}} or \code{\link[gt:html]{gt::html()}}. Must be \code{"md"} (default) or \code{"html"}.}

\item{...}{Specify a column and updated column label,
e.g. \code{modify_header(p.value = "Model P-values")}. This is provided as an alternative to the
\verb{update=} argument. They accomplish the same goal of updating column headers.}
}
\value{
Function return the same class of gtsummary object supplied
}
\description{
Column labels can be modified to include calculated statistics;
e.g. the N can be dynamically included by wrapping it in curly brackets
(following \link[glue:glue]{glue::glue} syntax).
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{modify_header_ex1.png}{options: width=45\%}}

\if{html}{Example 2}

\if{html}{\figure{modify_header_ex2.png}{options: width=45\%}}
}

\examples{
# create summary table
tbl <- trial[c("age", "grade", "trt")] \%>\%
  tbl_summary(by = trt, missing = "no") \%>\%
  add_p()

# print `.$table_body` to show column names and update headers
tbl$table_body

# Example 1 ----------------------------------
# updating column headers
modify_header_ex1 <-
  tbl \%>\%
  modify_header(
    update = list(
      label ~ "**Variable**",
      p.value ~ "**P**"
    )
  )

# Example 2 ----------------------------------
# using `stat_by=` argument to update headers
modify_header_ex2 <-
  tbl \%>\%
  modify_header(
    stat_by = "**{level}**, N = {n} ({style_percent(p)}\%)"
  )
}
\seealso{
Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p.tbl_summary}()},
\code{\link{add_q}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_summary}()},
\code{\link{inline_text.tbl_survfit}()},
\code{\link{modify_footnote}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_summary}()}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_footnote}()},
\code{\link{modify_spanning_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_uvregression tools}
