% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_cross.R
\name{tbl_cross}
\alias{tbl_cross}
\title{Create a cross table of summary statistics}
\usage{
tbl_cross(
  data,
  row = NULL,
  col = NULL,
  label = NULL,
  statistic = NULL,
  percent = c("none", "column", "row", "cell"),
  margin = c("column", "row"),
  missing = c("ifany", "always", "no"),
  missing_text = "Unknown",
  margin_text = "Total"
)
}
\arguments{
\item{data}{A data frame}

\item{row}{A column name in data to be used for columns
of cross table.}

\item{col}{A column name in data to be used for rows
of cross table.}

\item{label}{List of formulas specifying variables labels,
e.g. \code{list(age ~ "Age", stage ~ "Path T Stage")}.  If a
variable's label is not specified here, the label attribute
(\code{attr(data$age, "label")}) is used.  If
attribute label is \code{NULL}, the variable name will be used.}

\item{statistic}{A string with the statistic name in curly brackets to
be replaced with the numeric statistic (see glue::glue).
The default is \code{{n}}. If percent argument is \code{"column"}, \code{"row"}, or \code{"cell"},
default is \code{"{n} ({p}\%)"}.}

\item{percent}{Indicates the type of percentage to return.
Must be one of "none", "column", "row", or "cell". Default is "cell" when
\code{{N}} or \code{{p}} is used in statistic.}

\item{margin}{Indicates which margins to add to the table.
Default is \code{c("row", "column")}. Use \code{margin  = NULL} to suppress both
row and column margins.}

\item{missing}{Indicates whether to include counts of \code{NA} values in the table.
Allowed values are \code{"no"} (never display NA values),
\code{"ifany"} (only display if any NA values), and \code{"always"}
(includes NA count row for all variables). Default is \code{"ifany"}.}

\item{missing_text}{String to display for count of missing observations.
Default is \code{"Unknown"}.}

\item{margin_text}{Text to display for margin totals. Default is \code{"Total"}}
}
\value{
A \code{tbl_cross} object
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
The function creates a cross table of two categorical variables.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_cross_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_cross_ex2.png}{options: width=60\%}}
}

\examples{
# Example 1 ----------------------------------
tbl_cross_ex1 <-
  trial \%>\%
  tbl_cross(row = trt, col = response)

# Example 2 ----------------------------------
tbl_cross_ex2 <-
  trial \%>\%
  tbl_cross(row = stage, col = trt, percent = "cell") \%>\%
  add_p()

}
\seealso{
Other tbl_cross tools: 
\code{\link{add_p.tbl_cross}()},
\code{\link{inline_text.tbl_cross}()}
}
\author{
Karissa Whiting, Daniel D. Sjoberg
}
\concept{tbl_cross tools}
