% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_flex_table.R
\name{as_flex_table}
\alias{as_flex_table}
\title{Convert gtsummary object to a flextable object}
\usage{
as_flex_table(
  x,
  include = everything(),
  return_calls = FALSE,
  strip_md_bold = NULL
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}

\item{strip_md_bold}{DEPRECATED}
}
\value{
A {flextable} object
}
\description{
Function converts a gtsummary object to a flextable object.
A user can use this function if they wish to add customized formatting
available via the flextable functions. The flextable output is particularly
useful when combined with R markdown with Word output, since the gt package
does not support Word.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/as_flex_table_ex1.png" alt="image of rendered example table" style="width:60\%;">
}}
}

\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true") && broom.helpers::.assert_package("flextable", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
as_flex_table_ex1 <-
  trial \%>\%
  select(trt, age, grade) \%>\%
  tbl_summary(by = trt) \%>\%
  add_p() \%>\%
  as_flex_table()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other gtsummary output types: 
\code{\link{as_gt}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable_extra}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
