% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_number.R
\name{style_number}
\alias{style_number}
\title{Style numbers}
\usage{
style_number(
  x,
  digits = 0,
  big.mark = ifelse(decimal.mark == ",", " ", ","),
  decimal.mark = getOption("OutDec"),
  scale = 1,
  prefix = "",
  suffix = "",
  ...
)
}
\arguments{
\item{x}{(\code{numeric})\cr
Numeric vector}

\item{digits}{(non-negative \code{integer})\cr
Integer or vector of integers specifying the number of decimals
to round \code{x}. When vector is passed, each integer is mapped 1:1 to the
numeric values in \code{x}}

\item{big.mark}{(\code{string})\cr
Character used between every 3 digits to separate
hundreds/thousands/millions/etc.
Default is \code{","}, except when \code{decimal.mark = ","} when the default is a space.}

\item{decimal.mark}{(\code{string})\cr
The character to be used to indicate the numeric decimal point.
Default is \code{"."}  or \code{getOption("OutDec")}}

\item{scale}{(scalar \code{numeric})\cr
A scaling factor: \code{x} will be multiplied by scale before formatting.}

\item{prefix}{(\code{string})\cr
Additional text to display before the number.}

\item{suffix}{(\code{string})\cr
Additional text to display after the number.}

\item{...}{Arguments passed on to \code{base::format()}}
}
\value{
formatted character vector
}
\description{
Style numbers
}
\examples{
c(0.111, 12.3) |> style_number(digits = 1)
c(0.111, 12.3) |> style_number(digits = c(1, 0))
}
