% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.elliptical.R
\name{anova.elliptical}
\alias{anova.elliptical}
\title{Analysis of Deviance for Elliptical Model Fits}
\usage{
\method{anova}{elliptical}(object, dispersion = NULL,
  test = c("Chisq"), ...)
}
\arguments{
\item{object}{fit object for elliptical regression model.}

\item{dispersion}{the dispersion parameter for the fitting family, by default obtained from object.}

\item{test}{a character string representing that hypothesis test should be considered.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
An object of class \code{anova} inheriting from class \code{data.frame}
}
\description{
Compute an analysis of deviance table for one or more elliptical model fits.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5),
data=luz)
anova(elliptical.fitt)
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{ANOVA}
\keyword{elliptical}
