% Generated by roxygen2 (4.0.2): do not edit by hand
\name{as.h2o}
\alias{as.h2o}
\alias{as.h2o.H2OFrame}
\alias{as.h2o.Matrix}
\alias{as.h2o.data.frame}
\alias{as.h2o.default}
\title{Create H2OFrame}
\usage{
as.h2o(x, destination_frame = "", ...)

\method{as.h2o}{default}(x, destination_frame = "", ...)

\method{as.h2o}{H2OFrame}(x, destination_frame = "", ...)

\method{as.h2o}{data.frame}(x, destination_frame = "", ...)

\method{as.h2o}{Matrix}(x, destination_frame = "", ...)
}
\arguments{
\item{x}{An \code{R} object.}

\item{destination_frame}{A string with the desired name for the H2OFrame.}

\item{\dots}{arguments passed to method arguments.}
}
\description{
Import R object to the H2O cloud.
}
\details{
Method \code{as.h2o.data.frame} will use \code{\link[data.table]{fwrite}} if data.table package is installed in required version.
}
\examples{
\donttest{
h2o.init()
hi <- as.h2o(iris)
he <- as.h2o(euro)
hl <- as.h2o(letters)
hm <- as.h2o(state.x77)
hh <- as.h2o(hi)
stopifnot(is.h2o(hi), dim(hi)==dim(iris),
          is.h2o(he), dim(he)==c(length(euro),1L),
          is.h2o(hl), dim(hl)==c(length(letters),1L),
          is.h2o(hm), dim(hm)==dim(state.x77),
          is.h2o(hh), dim(hh)==dim(hi))
if (requireNamespace("Matrix", quietly=TRUE)) {
  data <- rep(0, 100)
  data[(1:10)^2] <- 1:10 * pi
  m <- matrix(data, ncol = 20, byrow = TRUE)
  m <- Matrix::Matrix(m, sparse = TRUE)
  hs <- as.h2o(m)
  stopifnot(is.h2o(hs), dim(hs)==dim(m))
}
}
}
\references{
\url{http://blog.h2o.ai/2016/04/fast-csv-writing-for-r/}
}
\seealso{
\code{\link{use.package}}
}

