% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.saveModel}
\alias{h2o.saveModel}
\title{Save an H2O Model Object to Disk}
\usage{
h2o.saveModel(object, path = "", force = FALSE)
}
\arguments{
\item{object}{an \linkS4class{H2OModel} object.}

\item{path}{string indicating the directory the model will be written to.}

\item{force}{logical, indicates how to deal with files that already exist.}
}
\description{
Save an \linkS4class{H2OModel} to disk. (Note that ensemble binary models
can be saved.)
}
\details{
In the case of existing files \code{force = TRUE} will overwrite the file.
Otherwise, the operation will fail.
}
\examples{
\dontrun{
# library(h2o)
# h2o.init()
# prostate.hex <- h2o.importFile(path = paste("https://raw.github.com",
#    "h2oai/h2o-2/master/smalldata/logreg/prostate.csv", sep = "/"),
#    destination_frame = "prostate.hex")
# prostate.glm <- h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"),
#    training_frame = prostate.hex, family = "binomial", alpha = 0.5)
# h2o.saveModel(object = prostate.glm, path = "/Users/UserName/Desktop", force=TRUE)
}
}
\seealso{
\code{\link{h2o.loadModel}} for loading a model to H2O from disk
}

